﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Newtonsoft.Json;
using Ext.Net;
using System.IO;
using System.Data;
using DataAccess;
using System.Collections;
using System.Web.Script.Serialization;
using System.Xml;

//setup an alias for all direct method calls on this control
[DirectMethodProxyID(IDMode = DirectMethodProxyIDMode.Alias, Alias = "UCNOTESEL")]

public partial class ucNoteSelection : System.Web.UI.UserControl
{
    public BaseMaster BaseMstr { get; set; }

    /// <summary>
    /// US:7112 show the note selection popup
    /// </summary>
    public void Show()
    {       
        wndSelectNote.Show();
    }

    public void Show2()
    {
        wndSelectNote.Modal = false;
        wndSelectNote.SetTitle("");
        //wndSelectNote.ShowAt(0, 0, false);

        wndSelectNote.Show();
    }

    /// <summary>
    /// US:7112 US:6048 load the clinics grid panel
    /// </summary>
    protected void LoadRecentClinics()
    {
        //clear the store
        storNoteClinic.SetDataFromJson(CDataUtils2.GetEmptyJSON());

        //get the dataset
        CPWEvent evt = new CPWEvent();
        DataSet dsClinic = evt.GetRecentClinicDS(BaseMstr);

        //load the store
        if (!CDataUtils2.IsEmpty(dsClinic))
        {
            //load the store
            CDataConverter cdc = new CDataConverter();
            storNoteClinic.SetDataFromJson(cdc.GetJsonDSString(dsClinic));
        }
        BaseMstr.Session["PING_MDWS"] = null;
    }

    /// <summary>
    /// 
    /// </summary>
    protected void LoadRecentNoteTitles()
    {
        //clear the store        
        gpNoteTitle.GetStore().RemoveAll();
        gpNoteTitle.Items.Clear();
        storNoteTitle.SetDataFromJson(CDataUtils2.GetEmptyJSON());

        //get the dataset
        CPWEvent evt = new CPWEvent();
        DataSet dsNoteTitle = evt.GetRecentNoteTitleDS(BaseMstr);

        //load the store
        if (!CDataUtils2.IsEmpty(dsNoteTitle))
        {
            //load the store
            CDataConverter cdc = new CDataConverter();
            storNoteTitle.SetDataFromJson(cdc.GetJsonDSString(dsNoteTitle));
        }
        BaseMstr.Session["PING_MDWS"] = null;
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///US:7112 user clicked the historical checkbox
    /// </summary>
    public void OnHistorical(bool bChecked, string strClinic)
    {
        if (dfNewVisitDate.SelectedDate.Year == 1)
        {
            return;
        }

        if (tfNewVisitTime.SelectedTime.Hours < 0)
        {
            return;
        }

        string strJSON = strClinic.Replace("[", "");
        strJSON = strJSON.Replace("]","");
        if (CDataUtils2.GetJsonRecordValue("CLINIC_LABEL", strJSON) == "")
        {
            return;
        }

        //rebuild the encounter string 
        OnClinicSelect(strJSON);
        BaseMstr.Session["PING_MDWS"] = null;
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///US:7112 user updated the date of the visit
    /// </summary>
    public void OnDateChange(string strClinic)
    {
        if (dfNewVisitDate.SelectedDate.Year == 1)
        {
            return;
        }

        if (tfNewVisitTime.SelectedTime.Hours < 0)
        {
            return;
        }

        string strJSON = strClinic.Replace("[", "");
        strJSON = strJSON.Replace("]", "");
        if (CDataUtils2.GetJsonRecordValue("CLINIC_LABEL", strJSON) == "")
        {
            return;
        }

        //rebuild the encounter string 
        OnClinicSelect(strJSON);
        BaseMstr.Session["PING_MDWS"] = null;
    }


    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///US:7112 user updated the time of the visit
    /// </summary>
    public void OnTimeChange(string strClinic)
    {
        if (dfNewVisitDate.SelectedDate.Year == 1)
        {
            return;
        }

        if (tfNewVisitTime.SelectedTime.Hours < 0)
        {
            return;
        }

        string strJSON = strClinic.Replace("[", "");
        strJSON = strJSON.Replace("]", "");
        if (CDataUtils2.GetJsonRecordValue("CLINIC_LABEL", strJSON) == "")
        {
            return;
        }

        //rebuild the encounter string 
        OnClinicSelect(strJSON);
        BaseMstr.Session["PING_MDWS"] = null;
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///US:7112 user closed the note selection dialog
    /// </summary>
    protected void OnEventNoteOK(object sender, DirectEventArgs e)
    {
        //todo: don't think we need these now
        string strNoteTitle = e.ExtraParams["ExtraParamNoteTitle"];
        strNoteTitle = strNoteTitle.Replace("\"", "");
        
        string strEncounterLocation = e.ExtraParams["ExtraParamEncLocation"];
        strEncounterLocation = strEncounterLocation.Replace("\"", "");
        
        string strCosigner = e.ExtraParams["ExtraParamCosigner"];
        strCosigner = strCosigner.Replace("\"", "");

        string strConsult = e.ExtraParams["ExtraParamConsult"];
        strConsult = strConsult.Replace("\"", "");

        //close the popup
        wndSelectNote.Close();
        BaseMstr.Session["PING_MDWS"] = null;
    }

  
    /// <summary>
    /// US:7112 US:6071 load vitits grid panel
    /// </summary>
    protected void LoadNoteVisitsGridPanel(DateTime dtFrom,
                                           DateTime dtTo)
    {
        //clear the store and the grid panel
        gpNoteVisit.GetStore().RemoveAll();
        gpNoteVisit.Items.Clear();
        storNoteVisit.SetDataFromJson(CDataUtils2.GetEmptyJSON());
      
        //get the dataset
        CNote note = new CNote();
        DataSet dsPatVisit = note.GetPatientVisitDS(BaseMstr,
                                                    dtFrom,
                                                    dtTo);
        //load the store
        if (!CDataUtils2.IsEmpty(dsPatVisit))
        {
            CDataConverter cdc = new CDataConverter();
            storNoteVisit.SetDataFromJson(cdc.GetJsonDSString(dsPatVisit));
        }
        BaseMstr.Session["PING_MDWS"] = null;
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>", Timeout = 60000)]
    /// <summary>
    /// US:7112 US:6071 search visits
    /// </summary>
    public void SearchVisits()
    {
        //validate the dates
        DateTime dtFromDate = dfVisitFromDate.SelectedDate;
        DateTime dtToDate = dfVisitToDate.SelectedDate;
        if (dtFromDate.Year == 1 ||
            dtToDate.Year == 1 ||
            (dtFromDate > dtToDate))
        {
            BaseMstr.ShowSystemFeedback("Please select a valid date range!", "Search Error");
            return;
        }

        //load the consults grid panel
        LoadNoteVisitsGridPanel(dtFromDate, dtToDate);
        BaseMstr.Session["PING_MDWS"] = null;
    }

    /// <summary>
    /// US:7301 US:7112 initialize the note selection dialog
    /// </summary>
    /// <returns></returns>
    public bool InitializeControl(string strTitle, string strEncLocation, string strConsult, string strCosigner)
    {
        tfNoteTitle.Text = strTitle;
        tfEncounterlocation.Text = strEncLocation;
        tfEncConsult.Text = strConsult;
        tfCoSigner.Text = strCosigner;
                
        /*tfNoteTitle.Text = "";
        tfEncounterlocation.Text = "";
        tfEncConsult.Text = "";
        tfCoSigner.Text = "";*/

        TabPanelNote.SetActiveTab("tpNoteTitles");

        //note titles
        gpNoteTitle.GetStore().RemoveAll();
        gpNoteTitle.Items.Clear();
        storNoteTitle.SetDataFromJson(CDataUtils2.GetEmptyJSON());
        
        //appts
        dfApptFromDate.SelectedDate = DateTime.Today.AddDays(-180);
        dfApptToDate.SelectedDate = DateTime.Today.AddDays(30);
        //LoadNoteApptGridPanel(dfApptFromDate.SelectedDate, dfApptToDate.SelectedDate);

        //visits
        dfVisitFromDate.SelectedDate = DateTime.Today.AddDays(-180);
        dfVisitToDate.SelectedDate = DateTime.Today;
        LoadNoteVisitsGridPanel(dfVisitFromDate.SelectedDate, dfVisitToDate.SelectedDate);
     
        //consults
        dfConsultFromDate.SelectedDate = DateTime.Today.AddDays(-180);
        dfConsultToDate.SelectedDate = DateTime.Today;
        LoadNoteConsultsGridPanel(dfConsultFromDate.SelectedDate, dfConsultToDate.SelectedDate);

        //admissions
        dfAdmitFromDate.SelectedDate = DateTime.Today.AddDays(-365);
        dfAdmitToDate.SelectedDate = DateTime.Today;
        LoadNoteAdmissionsGridPanel(dfApptFromDate.SelectedDate, dfApptToDate.SelectedDate);

        //hide consults and cosigners to start with
        if (String.IsNullOrEmpty(strConsult))
        {
            TabPanelNote.HideTab("tpConsults");
        }
        if (String.IsNullOrEmpty(strCosigner))
        {
            TabPanelNote.HideTab("tpCoSigner");
        }
        BaseMstr.Session["PING_MDWS"] = null;

        LoadRecentNoteTitles();
        LoadRecentClinics();

        return true;
    }

    /// <summary>
    /// US:7112 page load
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            //max date for a visit is now
            dfNewVisitDate.MaxDate = DateTime.Now;

            //clear session vars
            Session["SEL_NOTE_TITLE"] = "";
            Session["SEL_NOTE_CONSULT"] = "";
            Session["SEL_NOTE_LOCATION"] = "";
            Session["SEL_NOTE_COSIGN"] = "";
        }
    }


    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>", Timeout = 60000)]
    /// <summary>
    /// US:7112 US:6002 Note title select handler
    /// </summary>
    public void OnNoteTitleSelect(string strJsonRecord)
    {
        BaseMstr.Session["PING_MDWS"] = "1";

        tfEncounterlocation.Text = "";
        tfEncConsult.Text = "";
        tfCoSigner.Text = "";

        //set the note title text equal to the selected note title
        tfNoteTitle.Text = CDataUtils2.GetJsonRecordValue("NOTE_TITLE_LABEL", strJsonRecord);
        //tfNoteTitle.Text += "^" + CDataUtils2.GetJsonRecordValue("NOTE_TITLE_TAG", strJsonRecord);

        //no longer show the ^ details to the user, but still need them
        string strSELTitle = CDataUtils2.GetJsonRecordValue("NOTE_TITLE_LABEL", strJsonRecord);
        strSELTitle += "^" + CDataUtils2.GetJsonRecordValue("NOTE_TITLE_TAG", strJsonRecord);
        Session["SEL_NOTE_TITLE"] = strSELTitle;        
        
        //show/hide consults tab based on note selected
        if (CDataUtils2.GetJsonRecordValue("CONSULT_YN", strJsonRecord) == "Y")
        {
            TabPanelNote.ShowTab("tpConsults", 1);
        }
        else
        {
            TabPanelNote.HideTab("tpConsults");
        }

        //show/hide cosigner based on MDWS call to see if this note would require 
        //a cosigner for the note title IEN and the duz of the user logged in...
        string strIEN = CDataUtils2.GetJsonRecordValue("NOTE_TITLE_TAG", strJsonRecord);
        CMDWSOps ops = new CMDWSOps(BaseMstr.GetDataObject());
        if (ops.IsCosignerRequired(strIEN, BaseMstr.DUZ))
        {

            TabPanelNote.ShowTab("tpCoSigner", TabPanelNote.Items.Count-1);
        }
        else
        {
            TabPanelNote.HideTab("tpCoSigner");
        }

        BaseMstr.Session["PING_MDWS"] = null;
    }

    /// <summary>
    /// US:7112 user canceled the nopte selection dialog
    /// </summary>
    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>", Timeout = 60000)]
    public void OnNoteSelSelCancel()
    {
        wndSelectNote.Close();
    }
       
    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>", Timeout = 60000)]
    /// <summary>
    /// US:7112 US:6002 Search note titles
    /// </summary>
    public void SearchNoteTitles()
    {
        CStatus stat = new CStatus();

        //get the search text
        string strSearch = String.Empty;
        if (tfNoteTitleSearch.Text != null)
        {
            strSearch = tfNoteTitleSearch.Text;
        }

        if (strSearch.Length == 0)
        {
            BaseMstr.Session["PING_MDWS"] = null;
            LoadRecentNoteTitles();
            return;
        }

        //search must be at least 3 chars for performance reasons
        if (strSearch.Length < 3)
        {
            BaseMstr.Session["PING_MDWS"] = null;
        
            BaseMstr.ShowSystemFeedback("Note title search must be at least 3 characters!", "Search Error");
            return;
        }

        BaseMstr.Session["PING_MDWS"] = null;
        

        //load the note title grid panel
        LoadNoteTitleGridPanel(strSearch);
        BaseMstr.Session["PING_MDWS"] = null;
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>", Timeout = 60000)]
    /// <summary>
    /// US:7112 US:6005 search patient appointments
    /// </summary>
    public void SearchAppointments()
    {
        //validate the dates
        DateTime dtFromDate = dfApptFromDate.SelectedDate;
        DateTime dtToDate = dfApptToDate.SelectedDate;
        if (dtFromDate.Year == 1 ||
            dtToDate.Year == 1 ||
            (dtFromDate > dtToDate))
        {
            BaseMstr.ShowSystemFeedback("Please select a valid date range!", "Search Error");
            BaseMstr.Session["PING_MDWS"] = null;
            return;
        }

        //load the appointment grid panel
        LoadNoteApptGridPanel(dtFromDate, dtToDate);
        BaseMstr.Session["PING_MDWS"] = null;
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>", Timeout = 60000)]
    /// <summary>
    /// US:7112 US:6006 search patient admissions
    /// </summary>
    public void SearchAdmissions()
    {
        //validae the dates
        DateTime dtFromDate = dfAdmitFromDate.SelectedDate;
        DateTime dtToDate = dfAdmitToDate.SelectedDate;
        if (dtFromDate.Year == 1 ||
           dtToDate.Year == 1 ||
           (dtFromDate > dtToDate))
        {
            BaseMstr.ShowSystemFeedback("Please select a valid date range!", "Search Error");
            BaseMstr.Session["PING_MDWS"] = null;
            return;
        }

        //load the admissions grid panel
        LoadNoteAdmissionsGridPanel(dtFromDate, dtToDate);
        BaseMstr.Session["PING_MDWS"] = null;
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>", Timeout = 60000)]
    /// <summary>
    /// US:7112 US:6007 search consults
    /// </summary>
    public void SearchConsults()
    {
        //validate the dates
        DateTime dtFromDate = dfConsultFromDate.SelectedDate;
        DateTime dtToDate = dfConsultToDate.SelectedDate;
        if (dtFromDate.Year == 1 ||
            dtToDate.Year == 1 ||
            (dtFromDate > dtToDate))
        {
            BaseMstr.ShowSystemFeedback("Please select a valid date range!", "Search Error");
            BaseMstr.Session["PING_MDWS"] = null;
            return;
        }

        //load the consults grid panel
        LoadNoteConsultsGridPanel(dtFromDate, dtToDate);
        BaseMstr.Session["PING_MDWS"] = null;
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>", Timeout = 60000)]
    /// <summary>
    /// US:7112 US:6047 search cosigners
    /// </summary>
    public void SearchCosigner()
    {
        //get the search string
        string strSearch = String.Empty;
        if (tfCosignerSearch.Text != null)
        {
            strSearch = tfCosignerSearch.Text;
        }

        //search must be at least 3 chars for performance reasons
        if (strSearch.Length < 3)
        {
            BaseMstr.ShowSystemFeedback("Cosigner search must be at least 3 characters!", "Search Error");
            BaseMstr.Session["PING_MDWS"] = null;
            return;
        }

        //load the sconsults grid panel
        LoadNoteCosignersGridPanel(strSearch);
        BaseMstr.Session["PING_MDWS"] = null;
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>", Timeout = 60000)]
    /// <summary>
    /// US:7112 US:6048 search clinics
    /// </summary>
    public void SearchClinics()
    {
        CStatus stat = new CStatus();

        //get the search text
        string strSearch = String.Empty;
        if (tfClinicSearch.Text != null)
        {
            strSearch = tfClinicSearch.Text;
        }

        if (strSearch.Length == 0)
        {
            BaseMstr.Session["PING_MDWS"] = null;
            LoadRecentClinics();
            return;
        }

        //search must be at least 3 chars for performance reasons
        if (strSearch.Length < 3)
        {
            BaseMstr.ShowSystemFeedback("Clinic search must be at least 3 characters!", "Search Error");
            BaseMstr.Session["PING_MDWS"] = null;
            return;
        }

        //load the clinics grid panel
        LoadNoteClinicsGridPanel(strSearch);
        BaseMstr.Session["PING_MDWS"] = null;
    }

    /// <summary>
    /// US:7112 US:6005 load appointment grid panel
    /// </summary>
    protected void LoadNoteApptGridPanel(DateTime dtFrom,
                                         DateTime dtTo)
    {
        //clear the store
        storNoteAppt.SetDataFromJson(CDataUtils2.GetEmptyJSON());

        //get the dataset
        CNote note = new CNote();
        DataSet dsPatAppt = note.GetPatientAppointmentDS(BaseMstr,
                                                         dtFrom,
                                                         dtTo);
        //load the store
        if (!CDataUtils2.IsEmpty(dsPatAppt))
        {
            CDataConverter cdc = new CDataConverter();
            storNoteAppt.SetDataFromJson(cdc.GetJsonDSString(dsPatAppt));
        }
        BaseMstr.Session["PING_MDWS"] = null;
    }

    /// <summary>
    /// US:7112 US:6006 load admissions grid panel
    /// </summary>
    protected void LoadNoteAdmissionsGridPanel(DateTime dtFrom,
                                               DateTime dtTo)
    {
        //clear the store
        gpNoteAdmit.GetStore().RemoveAll();
        gpNoteAdmit.Items.Clear();
        storNoteAdmit.SetDataFromJson(CDataUtils2.GetEmptyJSON());
   
        //get the dataset
        CNote note = new CNote();
        DataSet dsPatAdmit = note.GetPatientAdmissionDS(BaseMstr,
                                                        dtFrom,
                                                        dtTo);
        //load the store
        if (!CDataUtils2.IsEmpty(dsPatAdmit))
        {
            CDataConverter cdc = new CDataConverter();
            storNoteAdmit.SetDataFromJson(cdc.GetJsonDSString(dsPatAdmit));
        }
        BaseMstr.Session["PING_MDWS"] = null;
    }

    
    /// <summary>
    /// US:7112 US:6007 load consult grid panel
    /// </summary>
    protected void LoadNoteConsultsGridPanel(DateTime dtFrom,
                                             DateTime dtTo)
    {
        //clear the store
        gpNoteConsult.GetStore().RemoveAll();
        gpNoteConsult.Items.Clear();
        storNoteConsult.SetDataFromJson(CDataUtils2.GetEmptyJSON());
  
        //get the dataset
        CNote note = new CNote();
        DataSet dsConsult = note.GetPatientConsultDS(BaseMstr,
                                                     dtFrom,
                                                     dtTo);

        //load the store
        if (!CDataUtils2.IsEmpty(dsConsult))
        {
            //load the store
            CDataConverter cdc = new CDataConverter();
            storNoteConsult.SetDataFromJson(cdc.GetJsonDSString(dsConsult));
        }
        BaseMstr.Session["PING_MDWS"] = null;
    }

    /// <summary>
    /// US:7112 US:6047 load cosigner grid panel
    /// </summary>
    /// <param name="strSearch"></param>
    protected void LoadNoteCosignersGridPanel(string strSearch)
    {
        //clear the store        
        storNoteCosigner.SetDataFromJson(CDataUtils2.GetEmptyJSON());

        //get the dataset
        CNote note = new CNote();
        DataSet dsCosigner = note.GetCosignerDS(BaseMstr,
                                                strSearch);

        //laod the store
        if (!CDataUtils2.IsEmpty(dsCosigner))
        {
            CDataConverter cdc = new CDataConverter();
            storNoteCosigner.SetDataFromJson(cdc.GetJsonDSString(dsCosigner));
        }
        BaseMstr.Session["PING_MDWS"] = null;
    }

    /// <summary>
    /// US:7112 US:6048 load the clinics grid panel
    /// </summary>
    protected void LoadNoteClinicsGridPanel(string strSearch)
    {
        //clear the store
        storNoteClinic.SetDataFromJson(CDataUtils2.GetEmptyJSON());

        //get the dataset
        CNote note = new CNote();
        DataSet dsClinic = note.GetClinicDS(BaseMstr,
                                            strSearch);

        //load the store
        if (!CDataUtils2.IsEmpty(dsClinic))
        {
            //load the store
            CDataConverter cdc = new CDataConverter();
            storNoteClinic.SetDataFromJson(cdc.GetJsonDSString(dsClinic));
        }
        BaseMstr.Session["PING_MDWS"] = null;
    }

    /// <summary>
    /// US:7112 US:6002 load note title grid panel
    /// </summary>
    protected void LoadNoteTitleGridPanel(string strSearch)
    {
        //clear the store        
        gpNoteTitle.GetStore().RemoveAll();
        gpNoteTitle.Items.Clear();
        storNoteTitle.SetDataFromJson(CDataUtils2.GetEmptyJSON());
   
        //get the dataset
        CNote note = new CNote();
        DataSet dsNoteTitle = note.GetNoteTitleDS(BaseMstr,
                                                  strSearch);

        //load the store
        if (!CDataUtils2.IsEmpty(dsNoteTitle))
        {
            //load the store
            CDataConverter cdc = new CDataConverter();
            storNoteTitle.SetDataFromJson(cdc.GetJsonDSString(dsNoteTitle));
        }
        BaseMstr.Session["PING_MDWS"] = null;
    }

    //////////////////////////////////////////////////////////////////////////////////////////
    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>", Timeout = 60000)]
    /// <summary>
    /// US:7112 US:6007 counsult select handler
    /// </summary>
    public void OnConsultSelect(string strJsonRecord)
    {
        tfEncConsult.Text = CDataUtils2.GetJsonRecordValue("CONSULT_DATETIME", strJsonRecord);
        tfEncConsult.Text += " ";
        tfEncConsult.Text += CDataUtils2.GetJsonRecordValue("CONSULT_TITLE", strJsonRecord);
        //tfEncConsult.Text += "^";
        //tfEncConsult.Text += CDataUtils2.GetJsonRecordValue("CONSULT_ID", strJsonRecord);

        //no long show the user ^ details but we still need it
        string strSELConsult = CDataUtils2.GetJsonRecordValue("CONSULT_DATETIME", strJsonRecord);
        strSELConsult += " ";
        strSELConsult += CDataUtils2.GetJsonRecordValue("CONSULT_TITLE", strJsonRecord);
        strSELConsult += "^";
        strSELConsult += CDataUtils2.GetJsonRecordValue("CONSULT_ID", strJsonRecord);
        Session["SEL_NOTE_CONSULT"] = strSELConsult;
        
        BaseMstr.Session["PING_MDWS"] = null;
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>", Timeout = 60000)]
    /// <summary>
    /// US:7112 US:6005 patient appointment select handler
    /// </summary>
    public void OnAppointmentSelect(string strJsonRecord)
    {
        string strSELEncounterLocation = "";
        
        //appointment date time and clinic
        tfEncounterlocation.Text = CDataUtils2.GetJsonRecordValue("APPT_DATETIME", strJsonRecord);
        tfEncounterlocation.Text += " ";
        tfEncounterlocation.Text += CDataUtils2.GetJsonRecordValue("CLINIC_LABEL", strJsonRecord);

        strSELEncounterLocation = tfEncounterlocation.Text;
        
        string strApptID = CDataUtils2.GetJsonRecordValue("APPT_ID", strJsonRecord);
        //2004-05-28T13:30:00 GENERAL MEDICINE^A;3040528.133;23
        string[] splitApptID = strApptID.Split(new Char[] { ';' });
        if (splitApptID.Length > 2)//valid string
        {
            //generate tiu note encounter string
            string strTIUEncounter = "";

            //clinic id
            strTIUEncounter += splitApptID[2]; //clinic id

            //date time
            //strTIUEncounter += ";" + CDataUtils2.GetJsonRecordValue("APPT_TIMESTAMP", strJsonRecord);
          
            DateTime dtnow = DateTime.Now;
            string strVisitTimeStamp = dtnow.ToString("yyyyMMdd.HHmmss");
            strTIUEncounter += ";" + strVisitTimeStamp;
          
            //splitApptID[1];

            //historical or not
            strTIUEncounter += ";" + splitApptID[0];

            //no longer show the details to the user
            //tfEncounterlocation.Text += "^" + strTIUEncounter;

            strSELEncounterLocation += "^" + strTIUEncounter;
        }

        Session["SEL_NOTE_LOCATION"] = strSELEncounterLocation;
        BaseMstr.Session["PING_MDWS"] = null;
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>", Timeout = 60000)]
    /// <summary>
    /// US:7112 US:6006 admission select handler
    /// </summary>
    public void OnAdmissionSelect(string strJsonRecord)
    {
        string strSELEncounterLocation = "";
       
        tfEncounterlocation.Text = CDataUtils2.GetJsonRecordValue("ADMIT_DATETIME", strJsonRecord);
        tfEncounterlocation.Text += " ";
        tfEncounterlocation.Text += CDataUtils2.GetJsonRecordValue("ADMIT_LOCATION_NAME", strJsonRecord);

        strSELEncounterLocation = tfEncounterlocation.Text;
      
        //generate tiu note encounter string
        //
        //from VA wiki
        //if the note is for current stay, 
        //encounterString = patient.locationId + ‘;’ + patient.admitTimestamp + ‘;H’ 
        //
        //if the note is for previous stay, call getAdmissions and have the user pick one. 
        //Then encounterString = stay.location.id + ‘;’ + stay.admitTimestamp + ‘;H’ 

        string strTIUEncounter = "";

        //clinic id
        strTIUEncounter += CDataUtils2.GetJsonRecordValue("ADMIT_LOCATION_ID", strJsonRecord);

        //date time
        strTIUEncounter += ";" + CDataUtils2.GetJsonRecordValue("ADMIT_TIMESTAMP", strJsonRecord);

        //H
        strTIUEncounter += ";H";

        //append the encounter to the selection
        
        //no longer show the user the details, but still need them
        //tfEncounterlocation.Text += "^" + strTIUEncounter;
        strSELEncounterLocation += "^" + strTIUEncounter;
        Session["SEL_NOTE_LOCATION"] = strSELEncounterLocation;

        BaseMstr.Session["PING_MDWS"] = null;
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>", Timeout = 60000)]
    /// <summary>
    /// US:7112 US:6071 visit select handler
    /// </summary>
    public void OnNoteVisitSelect(string strJsonRecord)
    {
        string strSELEncounterLocation = "";
     
        tfEncounterlocation.Text = CDataUtils2.GetJsonRecordValue("VISIT_DATETIME", strJsonRecord);
        tfEncounterlocation.Text += "  ";
        tfEncounterlocation.Text += CDataUtils2.GetJsonRecordValue("VISIT_LOCATION_NAME", strJsonRecord);
        tfEncounterlocation.Text += "  ";
        tfEncounterlocation.Text += CDataUtils2.GetJsonRecordValue("VISIT_TYPE", strJsonRecord);

        strSELEncounterLocation = tfEncounterlocation.Text;
      
        //generate tiu note encounter string
        //
        //from VA wiki
        //if the note is for current visit or previous visit, call getVisits and have the user pick one 
        //(we’ll make this nicer someday).
        //Then encounterString = visit.location.id + ‘;’ + visit.timestamp + ‘;A’ 
        string strTIUEncounter = "";

        //clinic id
        strTIUEncounter += CDataUtils2.GetJsonRecordValue("VISIT_LOCATION_ID", strJsonRecord);

        //date time
        strTIUEncounter += ";" + CDataUtils2.GetJsonRecordValue("VISIT_TIMESTAMP", strJsonRecord);

        //A
        strTIUEncounter += ";A";

        //append the encounter info to the selection

        //no longer show the user the details, but still need them
        //tfEncounterlocation.Text += "^" + strTIUEncounter;
        strSELEncounterLocation += "^" + strTIUEncounter;
        Session["SEL_NOTE_LOCATION"] = strSELEncounterLocation;
        
        BaseMstr.Session["PING_MDWS"] = null;
    }


    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>", Timeout = 60000)]
    /// <summary>
    /// US:7112 US:6048 clinic select handler
    /// </summary>
    public void OnClinicSelect(string strJsonRecord)
    {
        if (dfNewVisitDate.SelectedDate.Year == 1)
        {
            BaseMstr.ShowSystemFeedback("Please select a valid date!", "Data Entry Error");
            BaseMstr.Session["PING_MDWS"] = null;
            return;
        }

        if (tfNewVisitTime.SelectedTime.Hours < 0)
        {
            BaseMstr.ShowSystemFeedback("Please select a valid time!", "Data Entry Error");
            BaseMstr.Session["PING_MDWS"] = null;
            return;
        }

        string strSELEncounterLocation = "";
     
        tfEncounterlocation.Text = CDataUtils2.GetJsonRecordValue("CLINIC_LABEL", strJsonRecord);
        tfEncounterlocation.Text += " " + dfNewVisitDate.SelectedDate.ToShortDateString();
        tfEncounterlocation.Text += " " + tfNewVisitTime.SelectedTime.ToString();

        strSELEncounterLocation = tfEncounterlocation.Text;

        //generate tiu note encounter string
        string strTIUEncounter = "";
        
        //clinic id
        strTIUEncounter += CDataUtils2.GetJsonRecordValue("CLINIC_ID", strJsonRecord);

        //date time
        TimeSpan tsEntry = tfNewVisitTime.SelectedTime;
        DateTime dtEntryDateTime = new DateTime(dfNewVisitDate.SelectedDate.Year, 
                                                dfNewVisitDate.SelectedDate.Month, 
                                                dfNewVisitDate.SelectedDate.Day,
                                                tsEntry.Hours, 
                                                tsEntry.Minutes, 
                                                tsEntry.Seconds);
        
        //time stamp
        strTIUEncounter += ";" + dtEntryDateTime.ToString("yyyyMMdd.HHmm");

        //from VA wiki...
        //if the note is for a new visit, but not historical, call getLocations and have the user pick one. 
        //Then encounterString = location.id + ‘;’ + 20080515.1500 (today's date) + ‘;A’ 
        //
        //if the note is for a new visit, and is historical, then previous step but end with ‘;E’ instead of ‘;A’.
        //
        //historical or not
        if (!chkHistoricalNewVisit.Checked)
        {
            //if the note is for a new visit, but not historical, call getLocations and have the user pick one. 
            //Then encounterString = location.id + ‘;’ + 20080515.1500 (today's date) + ‘;A’ 
            strTIUEncounter += ";A";
        }
        else
        {
            //if the note is for a new visit, and is historical, then previous step but end with ‘;E’ instead of ‘;A’.
            strTIUEncounter += ";E";
        }
       
        //append the encounter string to the note
        //no longer show the user the details, but still need them
        //tfEncounterlocation.Text += "^" + strTIUEncounter;
        strSELEncounterLocation += "^" + strTIUEncounter;
        Session["SEL_NOTE_LOCATION"] = strSELEncounterLocation;
     
        BaseMstr.Session["PING_MDWS"] = null;
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>", Timeout = 60000)]
    /// <summary>
    /// US:7112 US:6047 Cosigner select handler
    /// </summary>
    public void OnCosignerSelect(string strJsonRecord)
    {
        string strSELCosign = "";
     
        tfCoSigner.Text = CDataUtils2.GetJsonRecordValue("NAME", strJsonRecord);
        tfCoSigner.Text += " ";
        tfCoSigner.Text += CDataUtils2.GetJsonRecordValue("TITLE", strJsonRecord);

        strSELCosign = tfCoSigner.Text;

        //no longer show the user ^ details but still need it
        //tfCoSigner.Text += "^" + CDataUtils2.GetJsonRecordValue("DUZ", strJsonRecord);
        strSELCosign += "^" + CDataUtils2.GetJsonRecordValue("DUZ", strJsonRecord);

        Session["SEL_NOTE_COSIGN"] = strSELCosign;
        
        BaseMstr.Session["PING_MDWS"] = null;
    }

}